unit DialogFindRoot;
//=============================================================================
//           c
//           .
//           DELPHI
//  (c)  ..  1.1.  25.12.2009.
//=============================================================================
//     INTERFACE
//=============================================================================
interface
uses SysUtils, AnsiTo866, Tools1v2, MyMath1V2;

// ---------------------------------------------------------
//    
procedure InitCodeEnd ();

// ---------------------------------------------------------
// .       .
// (         .)
procedure InputSourceData (RqKArray : array of double);

// ---------------------------------------------------------
// .      
//       .
procedure RunFindXRoot(RqKArray : array of double);

// ----------------------------------------------------------------------------



//=============================================================================
//     IMPLEMENTATION
//=============================================================================
implementation
// ----------------------------------------------------------------------------
//     
var
  F0        : double;  //    
  XB        : double;  //     
  XE        : double;  //     
  CodeEndF0 : byte;    // 0 -   
  CodEndXb  : byte;    // 0 -    
  CodEndXe  : byte;    // 0 -    

// ---------------------------------------------------------
//    (    
// )    
function FindXRoot(RqKArray : array of double): boolean;
//  FindXRoot
const  DeltaF   = 1E-10;   //     
const  FindNumb = 64;      // .     
//   FindXRoot
var    FB     : double;    //    B
       FE     : double;    //    E
       FUP    : boolean;   //   - True,  - False
       Found  : boolean;   //  () " "
       CNumb  : integer;   //   ()
       NewX   : double;    //    -   ()
       NewF   : double;    //   F -   ()
//   FindXRoot
procedure ReportFindXRoot();
begin
     //     
     WriteLnRus(' ! ');
     WriteLnRus('    =  ' + IntToStr(CNumb));
     WriteLnRus('    =  ' + FloatToStr(NewX));
     WriteLnRus('  =  ' + FloatToStr(NewF));
     WriteLnRus('     =  ' + FloatToStr(F0));
     WriteLnRus('   =  ' + FloatToStr(NewF-F0));
     WriteLn;
end; // of ReportFindXRoot()
begin
  //    
  FB := PPolynom(RqKArray, XB);
  FE := PPolynom(RqKArray, XE);
  Found := False;           //  " "
  CNumb := 0;               //   ()
   //        ?
  if (Abs(FB - F0) <= DeltaF) or (Abs(FE - F0) <= DeltaF)
  then begin
     //  
     Found := true;
     if (Abs(FB - F0) <= DeltaF)
     then begin
        //   Delta 
        NewX := XB;
        NewF := FB;
     end
     else begin
        //   Delta 
        NewX := XE;
        NewF := FE;
     end;
     //     
     ReportFindXRoot();
  end
  // ,   ,  
  else begin
      //    -   
      FUP := False;
      if FE > FB then FUP := True;
      //  
      repeat
         //       XB..XE
         NewX := XB + ( XE - XB )/2;
         NewF := PPolynom(RqKArray, NewX );
         if Abs(NewF - F0) <= DeltaF
         then begin
            Found := True;    //  
            //     
            ReportFindXRoot();
         end
         else begin
            //    
            if FUP
            then begin
               //   
               if F0 > NewF
               then XB := NewX
               else XE := NewX;
            end
            else begin
               //   
               if F0 < NewF
               then XB := NewX
               else XE := NewX;
            end;
         end; {if Abs(NewF - F0) <= DeltaF}
         CNumb := CNumb + 1;
      until Found or (CNumb > FindNumb)
  end; {if (FB = F0) or (FE = F0)}

  if not Found
  then begin
     //  
     WriteLnRus(' ! ');
     WriteLnRus('    = ' + IntToStr(CNumb));
     WriteLn;
  end;
  Result := Found;
end;

// ----------------------------------------------------------------------------
//    
function InputFloatValue(InvitMsg : string; var Val : double) : byte;
var WStr  : string;
begin
  Result := 2;                //  -    
  repeat
    WriteRus (InvitMsg);      //     
    ReadLn(WStr);             //    
    if UpCase(WStr[1]) = 'Q'
    then Result := 1          //    (Result := 1;)
    else begin
      //        Result := 0;
      if StrToFloatPro (WStr, Val)
      then Result := 0
      else Val := 0;
    end;
  //         
  until (Result = 0) or (Result = 1);
end;

// ----------------------------------------------------------------------------
//     
procedure WallReport (RqRep : char; WX, WPOL : double);
begin
   Case UpCase(RqRep) of
   'S' : begin
         WriteLnRus ('    OK!    : ' + FloatToStr(WX));
         WriteLnRus ('      X,  = ' + FloatToStr(WPOL));
         WriteLnRus ('       ');
         end;
   else  begin
         WriteLnRus ('    !     = ' + FloatToStr(WX));
         WriteLnRus ('      X,  = ' + FloatToStr(WPOL));
         WriteLnRus ('         Q');
         end
   end;
end;

// ----------------------------------------------------------------------------
// .  ,      .
function FindLowX (RqKArray : array of double;
                   RqF0 : double; var Xb : double): byte;
var WPOL : double;
begin
  WriteLnRus(' ,      ');
  repeat
     Result := InputFloatValue ('    = ', Xb);
     if Result = 0
     then begin
       //    
       WPOL := PPolynom(RqKArray, Xb);
       if WPOL <= RqF0
       then begin
         //     
         Result := 0;                  //   
         WallReport ('S', Xb, WPOL);   //  
       end
       else begin
         //     
         Result := 2;                  //   
         WallReport (' ', Xb, WPOL);    //   
       end;
     end;
  //          
  until (Result = 0) or (Result = 1);
  WriteLn;
end;

// ----------------------------------------------------------------------------
// .  ,      .
function FindHighX (RqKArray : array of double;
                   RqF0 : double; var Xe : double): byte;
var WPOL : double;
begin
  WriteLnRus(' ,      ');
  repeat
     Result := InputFloatValue ('    = ', Xe);
     if Result = 0
     then begin
       //      
       WPOL := PPolynom(RqKArray, Xe);
       if WPOL >= RqF0
       then begin
         //     
         Result := 0;                  //   
         WallReport ('S', Xe, WPOL);   //  
       end
       else begin
         //     
         Result := 2;                  //   
         WallReport (' ', Xe, WPOL);    //   
       end;
     end;
  //          
  until (Result = 0) or (Result = 1);
  WriteLn;
end;

// ---------------------------------------------------------
//    
procedure InitCodeEnd ();
begin
   CodeEndF0 := 1;  //  =     
   CodEndXb  := 1;  //  =     
   CodEndXe  := 1;  //  =     
end;

// ---------------------------------------------------------
// .       
procedure InputSourceData (RqKArray : array of double);
begin
 //    
 InitCodeEnd ();
 //    
 CodeEndF0 := InputFloatValue ('    : ', F0);
 WriteLn;
 if (CodeEndF0 = 0)
 then begin
   //  ,       .
   CodEndXb := FindLowX (RqKArray, F0, XB);
   if (CodEndXb = 0)
   then begin
      //  ,        .
      CodEndXe := FindHighX (RqKArray, F0, XE);
   end;
 end;
end;

// ---------------------------------------------------------
// .      
//       .
procedure RunFindXRoot(RqKArray : array of double);
var Ind : integer;
    Sum : double;
begin
  // ,       
  Sum := 0;
  for Ind := Low(RqKArray) to High(RqKArray)
  do begin
    Sum := Sum + Abs(RqKArray[Ind]);
  end;
  //    (Sum > 0),    
  if Sum > 0
  then begin
     if CodeEndF0 + CodEndXb + CodEndXe > 0
     then begin
        WriteLnRus('   ');
        WriteLnRus('    ');
        WriteLn;
     end
     else FindXRoot(RqKArray); //   
  end
  else begin
    WriteLnRus('   ');
    WriteLnRus('   ');
    WriteLn;
  end;
end;


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
end.
